"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const fs_1 = require("fs");
const loader_1 = require("./loader.cjs");
function i18n(options = 'lang') {
    var _a, _b;
    let langPath = typeof options === 'string' ? options : (_a = options.langPath) !== null && _a !== void 0 ? _a : 'lang';
    langPath = langPath.replace(/[\\/]$/, '') + path_1.default.sep;
    const additionalLangPaths = typeof options === 'string' ? [] : (_b = options.additionalLangPaths) !== null && _b !== void 0 ? _b : [];
    const frameworkLangPath = 'vendor/laravel/framework/src/Illuminate/Translation/lang/'.replace('/', path_1.default.sep);
    let files = [];
    let exitHandlersBound = false;
    const clean = () => {
        files.forEach((file) => {
            const filePath = langPath + file.name;
            if ((0, fs_1.existsSync)(filePath)) {
                (0, fs_1.unlinkSync)(filePath);
            }
        });
        files = [];
        if ((0, fs_1.existsSync)(langPath) && (0, fs_1.readdirSync)(langPath).length < 1) {
            (0, fs_1.rmdirSync)(langPath);
        }
    };
    return {
        name: 'i18n',
        enforce: 'post',
        config(config) {
            /** @ts-ignore */
            process.env.VITE_LARAVEL_VUE_I18N_HAS_PHP = true;
            return {
                define: {
                    'process.env.LARAVEL_VUE_I18N_HAS_PHP': true
                }
            };
        },
        buildEnd: clean,
        buildStart() {
            if (!(0, loader_1.hasPhpTranslations)(frameworkLangPath) && !(0, loader_1.hasPhpTranslations)(langPath)) {
                return;
            }
            const langPaths = (0, loader_1.prepareExtendedParsedLangFiles)([frameworkLangPath, langPath, ...additionalLangPaths]);
            files = (0, loader_1.generateFiles)(langPath, langPaths);
        },
        handleHotUpdate(ctx) {
            if (/lang\/.*\.php$/.test(ctx.file)) {
                const langPaths = (0, loader_1.prepareExtendedParsedLangFiles)([frameworkLangPath, langPath, ...additionalLangPaths]);
                files = (0, loader_1.generateFiles)(langPath, langPaths);
            }
        },
        configureServer(server) {
            if (exitHandlersBound) {
                return;
            }
            process.on('exit', clean);
            process.on('SIGINT', process.exit);
            process.on('SIGTERM', process.exit);
            process.on('SIGHUP', process.exit);
            exitHandlersBound = true;
        }
    };
}
exports.default = i18n;
//# sourceMappingURL=vite.cjs.map